function pre_attack_function_spells( animEventName : name, animEventType : EAnimationEventType, data : CPreAttackEventData, animInfo : SAnimationEventAnimInfo  ) : name
{
	var weaponEntity				: CItemEntity;
	var range_name     				: name;
	var effect, effect_0			: CEntity;
	var weapon						: CEntity;
	var weaponSlotMatrix 			: Matrix;
	
	range_name = data.rangeName;
	//theGame.witcherLog.AddMessage("RANGE NAME  " + (string)range_name );
	
	if ( thePlayer.HasBuff( EET_AssassinBless ) 
		&& !((W3PlayerWitcher)thePlayer).HasRunewordActive('Runeword 2 _Stats')
		&& !GetMagicVigil().is_inside_energy 
		&& is_holding_sword_spells()
		&& thePlayer.GetCurrentStateName() != 'CombatFists'
		)
	{
		if ( data.attackName == 'attack_heavy' || data.attackName == 'attack_heavy_special' )
		{
			range_name = 'runeword2_heavy';		
			weaponEntity = thePlayer.inv.GetItemEntityUnsafe(thePlayer.inv.GetItemFromSlot(data.weaponSlot));
			weaponEntity.PlayEffectSingle('heavy_trail_extended_fx');
		}
		else if ( data.attackName == 'attack_light' || data.attackName == 'attack_light_special' )
		{
			range_name = 'runeword2_light';		
			weaponEntity = thePlayer.inv.GetItemEntityUnsafe(thePlayer.inv.GetItemFromSlot(data.weaponSlot));
			weaponEntity.PlayEffectSingle('light_trail_extended_fx');
		}
	}
	
	
	if ( GetMagicVigil().is_inside_energy && is_holding_sword_spells() )
	{
		if ( data.attackName != 'attack_heavy_special' && data.attackName != 'attack_light_special' )
		{
			range_name = 'specialattacklight';
		}
		
		theGame.GetEntityByTag( 'energy_circle_lightning_sword' ).PlayEffect('sword_lightning');
	}
	else if ( GetMagicVigil().is_inside_veil && is_holding_sword_spells() )
	{
		theGame.GetEntityByTag( 'spells_veil_sword' ).PlayEffect('sword_veil_trail');
	}
	else if ( thePlayer.HasBuff( EET_LukatielSword ) && is_holding_sword_spells() )
	{
		if ( thePlayer.GetStat( BCS_Focus ) >= 2.0f && !theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'disable_effects_on_sword') ) 
		{
			if ( !theGame.GetEntityByTag( 'lukatiel_sword_trails' ) )
			{
				effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( 'sword_ring_small_effects' ), thePlayer.GetWorldPosition() );
				effect.CreateAttachment( thePlayer, 'r_weapon', Vector( 0, 0, 1.0 ) );
				effect.AddTag('lukatiel_sword_trails');
			}
			
			effect_0 = theGame.GetEntityByTag( 'lukatiel_sword_trails' );
			switch( GetWitcherPlayer().GetEquippedSign() )
			{
				case ST_Aard:
					{
						effect_0.PlayEffectSingle('sword_aard_trail');	
						effect_0.StopEffect('sword_aard_trail');	
					}
					break;
				case ST_Axii:
					{
						effect_0.PlayEffectSingle('sword_axii_trail');	
						effect_0.StopEffect('sword_axii_trail');	
					}
					break;
				case ST_Igni:
					{
						effect_0.PlayEffectSingle('sword_igni_trail');	
						effect_0.StopEffect('sword_igni_trail');	
					}
					break;
				case ST_Yrden:
					{
						effect_0.PlayEffectSingle('sword_yrden_trail');	
						effect_0.StopEffect('sword_yrden_trail');	
					}
					break;
				case ST_Quen:
					{
						effect_0.PlayEffectSingle('sword_quen_trail');	
						effect_0.StopEffect('sword_quen_trail');	
					}
					break;
				default:		
					break;
			}
		}
	}
	else
	{
		if ( theGame.GetEntityByTag( 'lukatiel_sword_trails' ) )
		{
			effect_0 = theGame.GetEntityByTag( 'lukatiel_sword_trails' );
			effect_0.RemoveTag('lukatiel_sword_trails');
			effect_0.StopAllEffects();
			effect_0.DestroyAfter(3);
		}
	}
	
	
	if ( data.attackName == 'attack_heavy_special' )
	{
		if( GetMagicVigil().can_cast_rend_lukatiel ) 
		{
			if ( animEventType == AET_DurationEnd )
			{
				GetMagicVigil().GotoState('SwordRingSpells');
			}
		}
	}
	
	//theGame.witcherLog.AddMessage("RANGE NAME  " + (string)range_name );
	
	return range_name;
}



function projectile_collision_spells( victim : CGameplayEntity, proj : CProjectileTrajectory, collidingComponent : CComponent ) 
{
	var entity_eff 					: CEntity;
	var rigidMesh 					: CMeshComponent;
	var speed_pr					: float;
	var effect_on_player			: CEntity;
	var deflect						: bool;

	deflect = false;

	if(collidingComponent)
		victim = (CGameplayEntity)collidingComponent.GetEntity();
	
	if ( victim == thePlayer )
	{
		//GetMagicVigil().set_hit_received( true );
	
		if ( guarding_buffs() )
		{
			if( proj.IsStopped() || proj.HasTag( 'spells_custom_projs' ) )
			{
				//theGame.witcherLog.AddMessage("HasTag( 'spells_custom_projs' ) "  );
				return;
			}
			
			if ( thePlayer.HasBuff( EET_BlackfireShield ) )
			{
				entity_eff = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( 'black_fire_effects' ), thePlayer.GetWorldPosition() );
				entity_eff.CreateAttachment( proj );
				entity_eff.PlayEffect( 'black_burning' );entity_eff.PlayEffect( 'black_burning' );
				entity_eff.StopEffect( 'black_burning' );
				entity_eff.DestroyAfter(2);
				
				deflect = true;
				speed_pr = 0.1;
			}
			else
			if ( thePlayer.HasBuff( EET_Wintershield ) )
			{
				entity_eff = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( 'wintersouls_effects' ), thePlayer.GetWorldPosition() );
				entity_eff.CreateAttachment( proj );
				entity_eff.PlayEffect( 'wintersouls_burning' );entity_eff.PlayEffect( 'wintersouls_burning' );
				entity_eff.StopEffect( 'wintersouls_burning' );
				entity_eff.DestroyAfter(2);
				
				deflect = true;
				speed_pr = 0.1;
			}
			else
			if ( thePlayer.HasBuff( EET_Energyshield ) )
			{
				effect_on_player = thePlayer.CreateFXEntityAtBone( 'spells_energy_effects', 'torso3', true );
				effect_on_player.PlayEffect('energy_lightning', proj );
				effect_on_player.DestroyAfter(3);
				
				proj.SoundEvent("sign_yrden_shock_activate");
				
				speed_pr = 0.7;
				deflect = true;
			}
			else
			if ( thePlayer.HasBuff( EET_QuilegShield ) )
			{
				entity_eff = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( 'quileg_effects' ), thePlayer.GetWorldPosition() );
				entity_eff.CreateAttachment( proj );
				entity_eff.PlayEffect( 'quileg_burning' );entity_eff.PlayEffect( 'quileg_burning' );
				entity_eff.StopEffect( 'quileg_burning' );
				entity_eff.DestroyAfter(2);
				
				deflect = true;
				speed_pr = 0.1;
			}
		}
		else
		if ( GetMagicVigil().is_inside_energy )
		{
			effect_on_player = thePlayer.CreateFXEntityAtBone( 'spells_energy_effects', 'torso3', true );
			effect_on_player.PlayEffect('energy_lightning', proj );
			effect_on_player.DestroyAfter(3);
			
			proj.SoundEvent("sign_yrden_shock_activate");
		
			deflect = true;
			speed_pr = 0.3;
		}
		else
		if ( theGame.GetEntityByTag('quen_sphere_fists') )
		{
			theGame.GetEntityByTag('quen_sphere_fists').PlayEffect('yrden_shock_activate', proj );
			proj.SoundEvent("sign_yrden_shock_activate");
			deflect = true;
			speed_pr = 0.3;
		}
		else
		if ( theGame.GetEntityByTag('xbow_energy') )
		{
			theGame.GetEntityByTag('xbow_energy').PlayEffect('yrden_shock_activate', proj );
			proj.SoundEvent("sign_yrden_shock_activate");
			deflect = true;
			speed_pr = 0.3;
		}
		
			
		if ( deflect )
		{
			proj.StopProjectile();
			
			rigidMesh = (CMeshComponent)proj.GetComponentByClassName('CRigidMeshComponent');
			
			if ( rigidMesh )
			{
				rigidMesh.SetEnabled( true );
			}
			else
			{
				proj.bounceOfVelocityPreserve = speed_pr;
				proj.BounceOff(VecRand2D(),proj.GetWorldPosition());
				proj.Init(thePlayer);
			}
		}
	}
}


function take_damage_function_spells( action : W3DamageAction )
{
	var return_dmg, add_action, add_action2				: W3DamageAction;
	var damage_val, dmg_red, dmg_taken					: float;
	var effect, effect_on_player						: CEntity;
	var totalDmg, addDmg, currentDmg                    : float;
	var monsterCategory 								: EMonsterCategory;
	var tmpName 										: name;
	var tmpBool 										: bool;
	var crit_chance										: float;
	
	if ( action.victim == thePlayer && ( action.IsActionMelee() || action.IsActionRanged() || action.IsActionWitcherSign() || action.IsActionEnvironment() ) && !action.IsDoTDamage() )
	{
		//GetMagicVigil().set_hit_received( true );
	
		if ( ((CActor) action.attacker).HasBuff( EET_CurseOfAssassin ) )
		{
			//theGame.witcherLog.AddMessage("damage_taken  = " + action.processedDmg.vitalityDamage );
			
			action.processedDmg.vitalityDamage -= action.processedDmg.vitalityDamage * ( get_spellpower_spells( false, S_Magic_5 ) * get_spellpower_mult() * 0.5 );
			
			//theGame.witcherLog.AddMessage("damage_taken left  = " + action.processedDmg.vitalityDamage );
			//theGame.witcherLog.AddMessage("damage_taken %%%%%  = " + ( get_spellpower_spells( false, S_Magic_5 ) * get_spellpower_mult() * 0.5 ) );
		}
	
	
		if ( GetMagicVigil().is_inside_energy || GetMagicVigil().is_inside_veil )
		{
			dmg_taken = action.processedDmg.vitalityDamage;
			dmg_red = dmg_taken * get_spellpower_spells( false, S_Magic_3 ) * get_spellpower_mult();
			dmg_red += dmg_red * get_shields_red_damage(); 
			
			action.processedDmg.vitalityDamage -= dmg_red;
			action.SetHitAnimationPlayType(EAHA_ForceNo);
			action.SetCanPlayHitParticle( false );
		}
		
		if ( guarding_buffs() )
		{
			if ( action.IsActionMelee() && action.processedDmg.vitalityDamage >0 )
			{
				damage_val = ( action.processedDmg.vitalityDamage * ( get_spellpower_spells( false, S_Magic_4 ) * get_spellpower_mult() ) );
				damage_val = ClampF(damage_val, 0, ( action.processedDmg.vitalityDamage ) ); 
				damage_val += damage_val * get_shields_ret_damage();
				
				return_dmg =  new W3DamageAction in theGame.damageMgr;
				return_dmg.Initialize( thePlayer, action.attacker, NULL, thePlayer.GetName()+"_sign", EHRT_Heavy, CPS_Undefined, false, false, true, false);
				return_dmg.SetProcessBuffsIfNoDamage(true);
				return_dmg.SetHitAnimationPlayType(EAHA_Default);
			
				if ( thePlayer.HasBuff( EET_BlackfireShield ) )
				{
					return_dmg.AddDamage( theGame.params.DAMAGE_NAME_ELEMENTAL, sp_elem_dmg_mod() * damage_val*0.5 );
					return_dmg.AddDamage( theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * 	 	damage_val*0.5 );
					
					effect = ((CActor) action.attacker).CreateFXEntityAtPelvis( 'black_fire_effects', true );
					effect.PlayEffect( 'black_flame' );
					effect.PlayEffect( 'black_shield_hit_actor_sound' );
					effect.StopEffect( 'black_shield_hit_actor_sound' );
					effect.DestroyAfter(5);
					
					effect_on_player = thePlayer.CreateFXEntityAtPelvis( 'black_fire_effects', true );
					effect_on_player.PlayEffect( 'black_shield_hit' );
					effect.DestroyAfter(3);
				}
				else
				if ( thePlayer.HasBuff( EET_Wintershield ) )
				{
					return_dmg.AddDamage( theGame.params.DAMAGE_NAME_FROST, sp_frost_dmg_mod() * damage_val );
					
					if( RandF() <= ( get_spellpower_spells( false, S_Magic_4 ) * 0.1 ) )
					{
						return_dmg.AddEffectInfo( EET_Frozen, get_spellpower_spells( false, S_Magic_4 ) *1.5 );
					}
					else 
					{
						return_dmg.AddEffectInfo( EET_SlowdownFrost, 2.5 );
					}
					
					effect = ((CActor) action.attacker).CreateFXEntityAtPelvis( 'wintersouls_effects', true );
					effect.PlayEffect( 'winter_shield_flame' );
					effect.PlayEffect( 'winter_shield_hit_actor_sound' );
					effect.StopEffect( 'winter_shield_hit_actor_sound' );
					effect.DestroyAfter(5);
					
					effect_on_player = thePlayer.CreateFXEntityAtPelvis( 'wintersouls_effects', true );
					effect_on_player.PlayEffect( 'winter_shield_hit' );
					effect.DestroyAfter(3);
				}
				else
				if ( thePlayer.HasBuff( EET_Energyshield ) )
				{
					return_dmg.AddDamage( theGame.params.DAMAGE_NAME_SHOCK, sp_shock_dmg_mod() * damage_val );
					
					effect = ((CActor) action.attacker).CreateFXEntityAtPelvis( 'energy_sword_hit', true );
					effect.PlayEffect( 'energy_hit_effect1' );
					effect.SoundEvent("sign_yrden_shock_activate");
					effect.DestroyAfter(5);
					
					effect_on_player = thePlayer.CreateFXEntityAtBone( 'spells_energy_effects', 'torso3', true );
					effect_on_player.PlayEffect('energy_lightning', effect );
					effect.DestroyAfter(3);
				}
				else
				if ( thePlayer.HasBuff( EET_QuilegShield ) )
				{
					return_dmg.AddDamage( theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage_val );
					
					effect = ((CActor) action.attacker).CreateFXEntityAtPelvis( 'quileg_effects', true );
					effect.PlayEffect( 'flame' );
					effect.PlayEffect( 'quileg_shield_hit_actor_sound' );
					effect.StopEffect( 'quileg_shield_hit_actor_sound' );
					effect.DestroyAfter(5);
					
					effect_on_player = thePlayer.CreateFXEntityAtPelvis( 'quileg_effects', true );
					effect_on_player.PlayEffect( 'quileg_shield_hit' );
					effect.DestroyAfter(3);
				}
				
				
				if ( spells_can_dismember( ((CActor) action.attacker) ) )
				{
					return_dmg.SetForceExplosionDismemberment();
				}
				
				theGame.damageMgr.ProcessAction( return_dmg );
				delete return_dmg;
			}
			
			action.SetHitAnimationPlayType(EAHA_ForceNo);
			action.SetCanPlayHitParticle( false );
			
			/*	
			action.processedDmg.vitalityDamage = 
				MinF( action.processedDmg.vitalityDamage - ( action.processedDmg.vitalityDamage * ( get_spellpower_spells( false, S_Magic_4 ) * get_spellpower_mult() ) ),
				thePlayer.GetMaxHealth()*0.2 );
			*/

			dmg_taken = action.processedDmg.vitalityDamage;
			dmg_red = dmg_taken * get_spellpower_spells( false, S_Magic_4 ) * get_spellpower_mult();
			dmg_red += dmg_red * get_shields_red_damage(); 
			
			action.processedDmg.vitalityDamage -= dmg_red;
			
			action.processedDmg.vitalityDamage = MinF( action.processedDmg.vitalityDamage, thePlayer.GetMaxHealth()*0.25 );
				
		}
		else 		
		{
			if ( action.processedDmg.vitalityDamage > 0 )
			{
				if ( GetMagicVigil().is_in_custom_anim )
				{
					//theGame.witcherLog.AddMessage("damage_taken is_in_custom_anim");
				}
				
				GetMagicVigil().damage_taken( ((CActor) action.attacker), action );
				
				//action.processedDmg.vitalityDamage = 100;
			}
		}
	}
	
	if ( action.attacker == thePlayer )
	{
		if ( action.IsActionMelee() && action.DealsAnyDamage() )
		{
			if ( GetMagicVigil().is_inside_energy && is_holding_sword_spells() )
			{
				effect = ((CActor) action.victim).CreateFXEntityAtPelvis( 'energy_sword_hit', true );
				effect.PlayEffect( 'energy_hit_effect1' );
				effect.SoundEvent("sign_yrden_shock_activate");
				effect.DestroyAfter(5);
				
				totalDmg = action.GetDamageDealt();
				
				action.SetUnderwaterDisplayDamageHack();
				
				//theGame.witcherLog.AddMessage("DAMAGE 0  " + (string)totalDmg );
				addDmg = totalDmg * get_spellpower_spells( false, S_Magic_3 ) * get_imbued_swords_mult();
				//theGame.witcherLog.AddMessage("DAMAGE  " + (string)addDmg );
				
				add_action = new W3DamageAction in theGame.damageMgr;
				add_action.Initialize(thePlayer,((CActor) action.victim),thePlayer,thePlayer.GetName(),EHRT_None,CPS_Undefined,false,false,true,false);
				add_action.SetProcessBuffsIfNoDamage(true);
				add_action.SetUnderwaterDisplayDamageHack();
				add_action.AddDamage( theGame.params.DAMAGE_NAME_SHOCK, sp_shock_dmg_mod() * addDmg );
				
				if ( spells_can_dismember( ((CActor) action.victim) ) )
				{
					add_action.SetForceExplosionDismemberment();
				}
				
				theGame.damageMgr.ProcessAction( add_action );
				
				((CActor) action.victim).ShowFloatingValue( EFVT_None, action.GetDamageDealt() + add_action.GetDamageDealt(), false );
				
				delete add_action;
			}
			else if ( GetMagicVigil().is_inside_veil && is_holding_sword_spells() )
			{
				effect = ((CActor) action.victim).CreateFXEntityAtPelvis( 'grave_warden', true );
				effect.PlayEffect( 'flame_short_cut' );
				effect.DestroyAfter(5);
			
				action.SetUnderwaterDisplayDamageHack();
				
				totalDmg = action.GetDamageDealt();
				addDmg = totalDmg * get_spellpower_spells( false, S_Magic_3 ) * get_imbued_swords_mult();
				
				theGame.GetMonsterParamsForActor( ((CActor) action.victim), monsterCategory, tmpName, tmpBool, tmpBool, tmpBool);
				if ( monsterCategory == MC_Specter || monsterCategory == MC_Vampire || monsterCategory == MC_Cursed  )
				{
					addDmg *= 1.10;
				}
				
				add_action2 = new W3DamageAction in theGame.damageMgr;
				add_action2.Initialize(thePlayer,((CActor) action.victim),thePlayer,thePlayer.GetName(),EHRT_None,CPS_Undefined,false,false,true,false);
				add_action2.SetProcessBuffsIfNoDamage(true);
				add_action2.SetUnderwaterDisplayDamageHack();
				add_action2.AddDamage( theGame.params.DAMAGE_NAME_DIRECT, sp_direct_dmg_mod() * addDmg );
				
				theGame.damageMgr.ProcessAction( add_action2 );
				
				((CActor) action.victim).ShowFloatingValue( EFVT_None, action.GetDamageDealt() + add_action2.GetDamageDealt(), false );
				
				delete add_action2;
			}
			else if ( thePlayer.HasBuff( EET_LukatielSword ) && is_holding_sword_spells() )
			{
				action.SetUnderwaterDisplayDamageHack();
			
				add_action = new W3DamageAction in theGame.damageMgr;
				add_action.Initialize(thePlayer,((CActor) action.victim),thePlayer,thePlayer.GetName(),EHRT_None,CPS_Undefined,false,false,true,false);
				add_action.SetProcessBuffsIfNoDamage(true);
				add_action.SetUnderwaterDisplayDamageHack();
				
				totalDmg = action.GetDamageDealt();
				addDmg = totalDmg * get_spellpower_spells_signs() * get_imbued_swords_mult();
				//theGame.witcherLog.AddMessage("additional damage  " + (string)addDmg );
				if ( thePlayer.GetStat( BCS_Focus ) >= 2.0f ) 
				{
					addDmg += addDmg * 0.1;
					//theGame.witcherLog.AddMessage("additional damage final  " + (string)addDmg );
				}
				//theGame.witcherLog.AddMessage("SPELLPOWER  " + (string)get_spellpower_spells_signs() );
				
				switch( GetWitcherPlayer().GetEquippedSign() )
				{
					case ST_Aard:
						{
							if ( RandF() <= 0.1 )
							{
								add_action.AddEffectInfo( EET_KnockdownTypeApplicator );
							}
							add_action.AddDamage( theGame.params.DAMAGE_NAME_FORCE, sp_force_dmg_mod() * addDmg );
							
							effect = ((CActor) action.victim).CreateFXEntityAtPelvis( 'sword_ring_small_effects', true );
							effect.PlayEffect( 'aard_sword_hit' );
							effect.SoundEvent("sign_quen_discharge_short");
							effect.DestroyAfter(5);
						}
						break;
					case ST_Axii:
						{
							if ( RandF() <= 0.2 )
							{
								((W3Action_Attack) add_action).SetApplyBuffsIfParried(true);
								add_action.AddEffectInfo( EET_SlowdownFrost, 3 );
							}
							add_action.AddDamage( theGame.params.DAMAGE_NAME_FROST, sp_frost_dmg_mod() * addDmg );
							
							effect = ((CActor) action.victim).CreateFXEntityAtPelvis( 'wintersouls_effects', true );
							/*if ( thePlayer.GetStat( BCS_Focus ) >= 2.0f ) 
							{
								effect.PlayEffect( 'wintersouls_flame' );
							}
							else*/
							{
								effect.PlayEffect( 'wintersouls_flame_cut' );
							}
							effect.PlayEffect( 'winter_shield_hit_actor_sound' );
							effect.StopEffect( 'winter_shield_hit_actor_sound' );
							effect.DestroyAfter(5);
						}
						break;
					case ST_Igni:
						{
							add_action.AddDamage( theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * addDmg  );
							
							if ( RandF() <= 0.1 )
							{
								add_action.AddEffectInfo( EET_Burning, 1 );
							}
							else
							{
								//((CActor) action.victim).AddTimer('Runeword1DisableFireFX', 0.5f);
								//((CActor) action.victim).PlayEffect('critical_burning');
								/*if ( thePlayer.GetStat( BCS_Focus ) >= 2.0f ) 
								{
									((CActor) action.victim).PlayEffect('fire_hit');
								}
								else*/
								{
									effect = ((CActor) action.victim).CreateFXEntityAtPelvis( 'swordless_hits', true );
									effect.PlayEffect( 'igni_slash_hit' );
									effect.DestroyAfter(5);
								}
								
								effect = ((CActor) action.victim).CreateFXEntityAtPelvis( 'wintersouls_effects', true );
								effect.PlayEffect( 'winter_shield_hit_actor_sound' );
								effect.StopEffect( 'winter_shield_hit_actor_sound' );
								effect.DestroyAfter(5);
							}
						}
						break;
					case ST_Yrden:
						{
							add_action.AddDamage( theGame.params.DAMAGE_NAME_SHOCK, sp_shock_dmg_mod() * addDmg );
							
							effect = ((CActor) action.victim).CreateFXEntityAtPelvis( 'sword_ring_small_effects', true );
							effect.PlayEffect( 'yrden_shock_cut' );
							effect.SoundEvent("sign_yrden_shock_activate");
							effect.DestroyAfter(5);
						}
						break;
					case ST_Quen:
						{
							if ( RandF() <= 0.2 )
							{
								((W3Action_Attack) add_action).SetApplyBuffsIfParried(true);
								add_action.AddEffectInfo( EET_Poison, 2 );
							}
							add_action.AddDamage(theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * addDmg * 0.5 );
							add_action.AddDamage(theGame.params.DAMAGE_NAME_POISON, sp_pois_dmg_mod() * addDmg * 0.5 );
							
							effect = ((CActor) action.victim).CreateFXEntityAtPelvis( 'great_swamp_effects', true );
							/*if ( thePlayer.GetStat( BCS_Focus ) >= 2.0f ) 
							{
								effect.PlayEffect( 'flame_from_cone' );
							}
							else*/
							{
								effect.PlayEffect( 'flame_short_cut' );
							}
							effect.DestroyAfter(5);
							
							effect = ((CActor) action.victim).CreateFXEntityAtPelvis( 'wintersouls_effects', true );
							effect.PlayEffect( 'winter_shield_hit_actor_sound' );
							effect.StopEffect( 'winter_shield_hit_actor_sound' );
							effect.DestroyAfter(5);
						}
						break;
					default:		
						break;
				}
				
				if ( spells_can_dismember( ((CActor) action.victim) ) )
				{
					add_action.SetForceExplosionDismemberment();
				}
				
				theGame.damageMgr.ProcessAction( add_action );
				
				((CActor) action.victim).ShowFloatingValue( EFVT_None, action.GetDamageDealt() + add_action.GetDamageDealt(), false );
				
				delete add_action;
				
			}
		}
		
		if ( thePlayer.HasBuff( EET_AssassinBless ) )
		{
			crit_chance = get_spellpower_spells( false, S_Magic_4 ) * 0.1;
			if ( RandF() <= crit_chance )
			{
				action.SetCriticalHit();
			}
			//theGame.witcherLog.AddMessage("CRIT : " + crit_chance );
		}
		
		if ( thePlayer.HasBuff( EET_Invisibilityspell ) )
		{	
			action.SetCriticalHit();
			
			if ( action.DealsAnyDamage() )
			{
				thePlayer.RemoveBuff( EET_Invisibilityspell );
			}
		}
	}
}


function ProcessPreHitModifications_spells( action : W3DamageAction )
{
}



/*
		action 				= act;
		playerAttacker 		= (CR4Player)action.attacker;
		playerVictim		= (CR4Player)action.victim;
		attackAction 		= (W3Action_Attack)action;		
		actorVictim 		= (CActor)action.victim;
		actorAttacker		= (CActor)action.attacker;
		dm 					= theGame.GetDefinitionsManager();
*/

function get_damage_value_for_stream( victim : CActor, spellpower_final : float ) : float
{
	var channelDmg 									: SAbilityAttributeValue;
	var damage_value 								: float;
		
	channelDmg = thePlayer.GetSkillAttributeValue(S_Magic_s02, 'channeling_damage', false, true);
	//channelDmg += thePlayer.GetSkillAttributeValue(S_Magic_s02, 'channeling_damage', false, false) * thePlayer.GetSkillLevel(S_Magic_s02); 			// delete for vanilla
	damage_value = channelDmg.valueAdditive + channelDmg.valueMultiplicative * victim.GetMaxHealth();
	damage_value += damage_value * spellpower_final * get_spellpower_mult();
	damage_value += damage_value * get_streams_increase();
	damage_value += damage_value * get_overall_mult();
	//damage_value *= 1.75;																															// delete for vanilla

	if(	!victim.IsHuman() && !victim.IsAnimal()	)
	{	
		damage_value += damage_value * get_monsters_mult();	
	}

	if ( theGame.GetInGameConfigWrapper().GetVarValue('magic_spells', 'spells_rand_dmg') )
	{
		damage_value *= RandRangeF(1.1, 0.9);
	}

	return damage_value;
}

function get_damage_value_for_cone( victim : CActor, spellpower_final : float ) : float
{
	var damage_value 								: float;

	damage_value = thePlayer.GetLevel() * get_player_level_cones();
	damage_value += damage_value * spellpower_final * get_spellpower_mult();
	damage_value += damage_value * get_overall_mult();
	
	if(	!victim.IsHuman() && !victim.IsAnimal()	)
	{	
		damage_value += damage_value * get_monsters_mult();	  
	}
	
	if ( theGame.GetInGameConfigWrapper().GetVarValue('magic_spells', 'spells_rand_dmg') )
	{
		damage_value *= RandRangeF(1.1, 0.9);
	}
	
	return damage_value;
}

function get_damage_value_for_blasts( victim : CActor, spellpower_final : float ) : float
{
	var damage_value 								: float;

	damage_value = thePlayer.GetLevel() * get_player_level_blasts();
	damage_value += damage_value * spellpower_final * get_spellpower_mult();
	damage_value += damage_value * get_overall_mult();
	
	if(	!victim.IsHuman() && !victim.IsAnimal()	)
	{	
		damage_value += damage_value * get_monsters_mult();	  
	}
	
	if ( theGame.GetInGameConfigWrapper().GetVarValue('magic_spells', 'spells_rand_dmg') )
	{
		damage_value *= RandRangeF(1.1, 0.9);
	}
	
	return damage_value;
}

function get_damage_value_for_trap( victim : CActor, spellpower_final : float ) : float
{
	var damage_value 								: float;

	damage_value = thePlayer.GetLevel() * get_player_level_traps();
	damage_value += damage_value * spellpower_final * get_spellpower_mult();
	damage_value += damage_value * get_overall_mult();
	
	if(	!victim.IsHuman() && !victim.IsAnimal()	)
	{	
		damage_value += damage_value * get_monsters_mult();	  
	}
	
	if ( theGame.GetInGameConfigWrapper().GetVarValue('magic_spells', 'spells_rand_dmg') )
	{
		damage_value *= RandRangeF(1.1, 0.9);
	}
	
	return damage_value;
}

function get_damage_value_for_special_trap( victim : CActor, spellpower_final : float ) : float
{
	var damage_value 								: float;

	damage_value = victim.GetMaxHealth()*0.01;
	damage_value += damage_value * spellpower_final * get_spellpower_mult();
	damage_value += damage_value * get_special_traps_mult();
	damage_value += damage_value * get_overall_mult();
	
	if ( theGame.GetInGameConfigWrapper().GetVarValue('magic_spells', 'spells_rand_dmg') )
	{
		damage_value *= RandRangeF(1.1, 0.9);
	}
	
	return damage_value;
}

function get_damage_value_for_projectile( victim : CActor, spellpower_final : float, optional include_player : bool ) : float
{
	var damage_value 								: float;

	damage_value = thePlayer.GetLevel() * get_player_level_projectiles();
	damage_value += damage_value * ( spellpower_final * get_spellpower_mult() );
	damage_value += damage_value * get_overall_mult();
	
	if(	!victim.IsHuman() && !victim.IsAnimal()	)
	{	
		damage_value += damage_value * get_monsters_mult();
	}
	if ( victim == thePlayer && !include_player )
	{
		damage_value = 0;
	}
	
	if ( theGame.GetInGameConfigWrapper().GetVarValue('magic_spells', 'spells_rand_dmg') )
	{
		damage_value *= RandRangeF(1.1, 0.9);
	}

	return damage_value;
}

function get_damage_value_for_cone_far( victim : CActor, spellpower_final : float ) : float
{
	var damage_value 								: float;
	
	damage_value = thePlayer.GetLevel() * get_player_level_cones_far();
	damage_value += damage_value * spellpower_final * get_spellpower_mult();
	damage_value += damage_value * get_overall_mult();
	
	if(	!victim.IsHuman() && !victim.IsAnimal()	)
	{	
		damage_value += damage_value * get_monsters_mult();	  
	}
	
	if ( theGame.GetInGameConfigWrapper().GetVarValue('magic_spells', 'spells_rand_dmg') )
	{
		damage_value *= RandRangeF(1.1, 0.9);
	}
	
	return damage_value;
}

function get_damage_value_for_meteors( victim : CActor, spellpower_final : float ) : float
{
	var damage_value 								: float;

	damage_value = thePlayer.GetLevel() * get_player_level_meteors();
	damage_value += damage_value * ( spellpower_final * get_spellpower_mult() );
	damage_value += damage_value * get_overall_mult();
	
	if(	!victim.IsHuman() && !victim.IsAnimal()	)
	{	
		damage_value += damage_value * get_monsters_mult();
	}
	if ( victim == thePlayer )
	{
		//theGame.witcherLog.AddMessage("damage_value  " + (string)damage_value );
		damage_value = damage_value - ( damage_value * ( spellpower_final * get_spellpower_mult() ) );
		//theGame.witcherLog.AddMessage("damage_value player  " + (string)( damage_value - ( damage_value * ( spellpower_final * 0.5 ) ) ) );
	}
	
	if ( theGame.GetInGameConfigWrapper().GetVarValue('magic_spells', 'spells_rand_dmg') )
	{
		damage_value *= RandRangeF(1.1, 0.9);
	}

	return damage_value;
}

function get_damage_value_for_iceblast( victim : CActor, spellpower_final : float ) : float
{
	var damage_value 								: float;

	damage_value = thePlayer.GetLevel() * get_player_level_iceblast();
	damage_value += damage_value * ( spellpower_final * get_spellpower_mult() );
	damage_value += damage_value * get_overall_mult();
	
	if(	!victim.IsHuman() && !victim.IsAnimal()	)
	{	
		damage_value += damage_value * get_monsters_mult();
	}
	if ( victim == thePlayer )
	{
		//theGame.witcherLog.AddMessage("damage_value  " + (string)damage_value );
		damage_value = damage_value - ( damage_value * ( spellpower_final * get_spellpower_mult() ) );
		//theGame.witcherLog.AddMessage("damage_value player  " + (string)( damage_value - ( damage_value * ( spellpower_final * 0.5 ) ) ) );
	}
	
	if ( theGame.GetInGameConfigWrapper().GetVarValue('magic_spells', 'spells_rand_dmg') )
	{
		damage_value *= RandRangeF(1.1, 0.9);
	}

	return damage_value;
}

function get_damage_value_for_quilegmet( victim : CActor, spellpower_final : float ) : float
{
	var damage_value 								: float;

	damage_value = thePlayer.GetLevel() * get_player_level_guilegmet();
	damage_value += damage_value * ( spellpower_final * get_spellpower_mult() );
	damage_value += damage_value * get_overall_mult();
	
	if(	!victim.IsHuman() && !victim.IsAnimal()	)
	{	
		damage_value += damage_value * get_monsters_mult();
	}
	if ( victim == thePlayer )
	{
		//theGame.witcherLog.AddMessage("damage_value  " + (string)damage_value );
		damage_value = damage_value - ( damage_value * ( spellpower_final * get_spellpower_mult() ) );
		//theGame.witcherLog.AddMessage("damage_value player  " + (string)( damage_value - ( damage_value * ( spellpower_final * 0.5 ) ) ) );
	}
	
	if ( theGame.GetInGameConfigWrapper().GetVarValue('magic_spells', 'spells_rand_dmg') )
	{
		damage_value *= RandRangeF(1.1, 0.9);
	}

	return damage_value;
}
